<?php

/***************************************************************************\
|                                                                           |
|  Copyright 2007 Image Validator                                           |
|  Pavel Tzonkov <pavelc@users.sourceforge.net>                             |
|                                                                           |
|  Image Validator is free software; you can redistribute it and/or modify  |
|  it under the terms of the GNU General Public License as published by     |
|  the Free Software Foundation; either version 2 of the License, or (at    |
|  your option) any later version.                                          |
|                                                                           |
|  Image Validator is distributed in the hope that it will be useful, but   |
|  WITHOUT ANY WARRANTY; without even the implied warranty of               |
|  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU         |
|  General Public License for more details.                                 |
|                                                                           |
|  You should have received a copy of the GNU General Public License along  |
|  with Image Validator; if not, write to the Free Software Foundation,     |
|  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA              |
|                                                                           |
\***************************************************************************/

session_start();

include("../dbinfo.php");

// Settings, feel free to adjust

$captcha_width = 125;
$captcha_height = 30;
$font_size = 15;
$char_amount = 6;
$lines_amount = 12;
$char_colors = "#880000,#008800,#000088,#888800,#880088,#008888,#000000";
$line_colors = "#DD6666,#66DD66,#6666DD,#DDDD66,#DD66DD,#66DDDD,#666666";
$bg_color = "#FFFFFF";
$allowed_chars = "ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz012345689";
$path = "fonts";
//$captcha_salt = "s"; //create a new CAPTCHA Salt for this session
global $captcha_salt;


// DO NOT CHANGE CODE BELOW UNLESS YOU KNOW WHAT YOU'RE DOING
$line_colors = preg_split("/,\s*?/", $line_colors);
$char_colors = preg_split("/,\s*?/", $char_colors);
$fonts = collect_files($path, "ttf");

$img = imagecreatetruecolor($captcha_width, $captcha_height);
imagefilledrectangle($img, 0, 0, $captcha_width - 1, $captcha_height - 1, gd_color($bg_color));


// Draw lines

for ($i = 0; $i < $lines_amount; $i++)
    imageline($img,
        rand(0, $captcha_width - 1),
        rand(0, $captcha_height - 1),
        rand(0, $captcha_width - 1),
        rand(0, $captcha_height - 1),
        gd_color($line_colors[rand(0, count($line_colors) - 1)])
    );


// Draw code

$code = "";
$y = ($captcha_height / 2) + ($font_size / 2);
for ($i = 0; $i < $char_amount; $i++) {
    $color = gd_color($char_colors[rand(0, count($char_colors) - 1)]);
    $angle = rand(-30, 30);
    $char = substr($allowed_chars, rand(0, strlen($allowed_chars) - 1), 1);
    $font = $path . "/" . $fonts[rand(0, count($fonts) - 1)];
    $x = (intval(($captcha_width / $char_amount) * $i) + ($font_size / 2));
    $code .= $char;
    imagettftext($img, $font_size, $angle, $x, $y, $color, $font, $char);
}

$_SESSION['captcha'] = md5($captcha_salt.$code);

header("Content-Type: image/png");
imagepng($img);
imagedestroy($img);


function gd_color($html_color) {
    return preg_match('/^#?([\dA-F]{6})$/i', $html_color, $rgb)
      ? hexdec($rgb[1]) : false;
}


function collect_files($dir, $ext) {
    if (false !== ($dir = opendir($dir))) {
        $files = array();

        while (false !== ($file = readdir($dir)))
            if (preg_match("/\\.$ext\$/i", $file))
                $files[] = $file;

        return $files;

    } else
        return false;
}

//Code thanks to Antonie Potgieter: http://www.lost-in-code.com/programming/php-code/php-random-string-with-numbers-and-letters/
function generateSalt() {
	 $length = 20;
     $characters = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
 
    for ($p = 0; $p < $length; $p++) {
         $string .= $characters[mt_rand(0, strlen($characters))];
     }
 
    return $string;
}
?>